require "BuildingObjects/ISBuildingObject"

HCBeamPillar = ISBuildingObject:derive("HCBeamPillar");

function HCBeamPillar:create(x, y, z, north, sprite)
	local cell = getWorld():getCell();
	local eHP = getSpecificPlayer(self.player):getPerkLevel(Perks.Woodwork)*50;
	local objHP = 100 + eHP;
	if getSpecificPlayer(self.player):HasTrait("Handy") then
		objHP = objHP + 100;
	end
	self.sq = cell:getGridSquare(x, y, z);
	self.javaObject = IsoThumpable.new(cell, self.sq, sprite, north, self);
	buildUtil.setInfo(self.javaObject, self);
	self.modData["need:Hydrocraft.HCWoodbeam"] = "1";
	buildUtil.consumeMaterial(self);
	self.javaObject:setMaxHealth(objHP);
	self.javaObject:setBreakSound("breakdoor");
	self.sq:AddTileObject(self.javaObject);
	self.sq:RecalcAllWithNeighbours(true);
	self.javaObject:transmitCompleteItemToServer();
end

function HCBeamPillar:new(sprite, player)
	local o = {};
	setmetatable(o, self);
	self.__index = self;
	o:init();
	o:setSprite(sprite);
	o:setNorthSprite(sprite);
	o.name = "Beam Pillar";
	o.canBarricade = false;
	o.dismantable = false;
	o.blockAllTheSquare = false;
	o.canBeAlwaysPlaced = false;
	o.noNeedHammer = true;
	o.character = player;
	return o;
end

function HCBeamPillar:render(x, y, z, square)
	ISBuildingObject.render(self, x, y, z, square);
end